#ifndef TriggerCommandsOffLine_Register_h
#define TriggerCommandsOffLine_Register_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class Register
 * \brief This class provides processing for REGISTER Trigger command.
 */
class Register : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string RegisterId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
public:
  Register();
  ~Register();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_Register_h

