/**
 * @file UEUserGuideClient.h
 * Provides a set of TTCN-3 recoder decoder  methods
 * @author Yann garcia
 * @version 1.0
 * @date 20/07/2009
 */

#ifndef TriggerCommandsGUI_UEUserGuideClient
#define TriggerCommandsGUI_UEUserGuideClient

#include<boost/shared_ptr.hpp>
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>

#include "Helper/Singleton.h"
#include "Helper/Socket.h"
#include "Helper/GeneralConfigurationParams.h"

#include "UEUserGuideClientMessages.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class UEUserGuideClient
 * \brief This class provides a set of convesion methods. It shall be used with Singleton class.
 */
class UEUserGuideClient : public Singleton<UEUserGuideClient>
{
private:
  //! Singleton implementation
  friend class Singleton<UEUserGuideClient>;
  
  //! Convertion map from char to int.
  boost::shared_ptr<SocketClient> m_client;
  
  //! UEUserGuideClient.
 /*! Default ctor.
  */
  UEUserGuideClient() { };

public:
  int SendCommand(boost::shared_ptr<EutIPInterface> eutIface, const std::string &trigger, const std::vector<std::string> &parameterList);
};

} } } // namespaces

#endif //  TriggerCommandsGUI_UEUserGuideClient
