#include "UdpDissector.h"
#include "Logger/Logger.h"
#ifdef WIN32
#include <Winsock2.h>
#else
#include <netinet/in.h>
#endif

UdpDissector::UdpDissector() :
	m_udpHdr(0)
{
}

UdpDissector::~UdpDissector() 
{
	delete m_udpHdr;
}

UdpDissector * UdpDissector::Clone() const {
  return new UdpDissector();
}

bool UdpDissector::Dissect(const unsigned char * pData, const ssize_t nDataLen) {
  if (!m_udpHdr)
    m_udpHdr = new UdpHeader;
  memcpy(m_udpHdr, pData, sizeof(UdpHeader));
#if BYTE_ORDER == LITTLE_ENDIAN
  m_udpHdr->destPort = ntohs(m_udpHdr->destPort);
  m_udpHdr->srcPort = ntohs(m_udpHdr->srcPort);
#endif
  pData += sizeof(UdpHeader);

  SavePayload(pData, nDataLen - sizeof(UdpHeader));
  SaveLayerInfo();
  return true;
}

bool UdpDissector::NeedReassembly() const {
  return false;
}

const EProtocolType UdpDissector::GetUpperLayerType() const 
{
	return EProtocolType_None;
}

ProtocolInfoElement * UdpDissector::CreateLayerInfo()
{
	UdpInfo * pRes = new UdpInfo();
	pRes->SetSourcePort(m_udpHdr->srcPort);
	pRes->SetDestinationPort(m_udpHdr->destPort);
	return pRes;
}
