#include "TriggerCommands.h"
#include <string>
#include <vector>
#include <iostream>

#include "Logger/Logger.h"

#include "Register.h"
#include "CheckIsRegistered.h"
#include "CheckIsNotRegistered.h"
#include "CheckCallIsInitialized.h"
#include "CheckCallIsAnswered.h"
#include "CheckCallIsEnded.h"
#include "CheckNewMediaAdded.h"
#include "CheckNewMediaRemoved.h"
#include "Default.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
TriggerCommands::TriggerCommands()
{
  m_successor = shared_ptr<TriggerCommandsImpl>(new Register); // Register
  shared_ptr<TriggerCommandsImpl> checkIsRegistered = shared_ptr<TriggerCommandsImpl>(new CheckIsRegistered); // CheckIsRegister
  m_successor.get()->SetSuccessor(checkIsRegistered);
  shared_ptr<TriggerCommandsImpl> checkIsNotRegistered = shared_ptr<TriggerCommandsImpl>(new CheckIsNotRegistered); // CheckIsNotRegister
  checkIsRegistered.get()->SetSuccessor(checkIsNotRegistered);
  shared_ptr<TriggerCommandsImpl> checkCallIsInitialized = shared_ptr<TriggerCommandsImpl>(new CheckCallIsInitialized); // CheckCallIsInitialized
  checkIsNotRegistered.get()->SetSuccessor(checkCallIsInitialized);
  shared_ptr<TriggerCommandsImpl> checkCallIsAnswered = shared_ptr<TriggerCommandsImpl>(new CheckCallIsAnswered); // CheckCallIsAnswered
  checkCallIsInitialized.get()->SetSuccessor(checkCallIsAnswered);
  shared_ptr<TriggerCommandsImpl> checkCallIsEnded = shared_ptr<TriggerCommandsImpl>(new CheckCallIsEnded); // CheckCallIsEnded
  checkCallIsAnswered.get()->SetSuccessor(checkCallIsEnded);
  shared_ptr<TriggerCommandsImpl> checkNewMediaAdded = shared_ptr<TriggerCommandsImpl>(new CheckNewMediaAdded); // CheckNewMediaAdded
  checkCallIsEnded.get()->SetSuccessor(checkNewMediaAdded);
  shared_ptr<TriggerCommandsImpl> checkNewMediaRemoved = shared_ptr<TriggerCommandsImpl>(new CheckNewMediaRemoved); // CheckNewMediaRemoved
  checkNewMediaAdded.get()->SetSuccessor(checkNewMediaRemoved);
  checkNewMediaRemoved.get()->SetSuccessor(shared_ptr<TriggerCommandsImpl>(new Default));

  Logger::Instance().LogInfo("TriggerCommandsOffLine::TriggerCommands::TriggerCommands: 9 commands created");
}

TriggerCommands::~TriggerCommands()
{
	m_successor.reset();
}

void TriggerCommands::SetEutIpInterface(boost::shared_ptr<EutIPInterface> eutIface)
{
  Logger::Instance().LogInfo("TriggerCommands::~TriggerCommands");
  m_successor.reset();
}

int TriggerCommands::Process(const string &trigger, const vector<string> &parameterList)
{
  // Sanity check,
  if (trigger.length() == 0)
  {
    Logger::Instance().LogError("TriggerCommandsOffLine::TriggerCommands::Process: trigger is empty.");
    return 1; // See TTCN-3 FncRetCode .
  }

  stringstream ss;
  ss << "TriggerCommandsOffLine::TriggerCommands::Process: start processing: " << trigger;
  Logger::Instance().LogInfo(ss.str());
  return m_successor.get()->Process(trigger, parameterList);
}

} } } // namespaces

