package org.etsi.t3d.visitor;

import java.util.LinkedList;

import org.etsi.t3d.ImportPrinter;
import org.etsi.t3d.T3D;
import org.etsi.t3d.exceptions.TTCN3BehaviorException;

import de.ugoe.cs.swe.trex.core.analyzer.rfparser.LocationAST;

public class ImportVisitor extends AbstractVisitor {

	private ImportPrinter importPrinter;
	private String filename;

	public ImportVisitor(ImportPrinter importPrinter) {
		this.importPrinter = importPrinter;
	}
	@Override
	public void finish() {
	}

	@Override
	public void init() {
		importPrinter.getLoggingInterface().setLogSourceName(this.getFilename());
		importPrinter.setCurrentTTCN3File(this.getFilename());
	}
	
	public ContinueStatus visitTTCN3Module(LocationAST node) throws TTCN3BehaviorException {
		importPrinter.newModule(VisitorCommonFunctions.getName(node));
		importPrinter.printImportView(node);
		if(T3D.activeProfile.isCheckCyclicImports())
			importPrinter.checkForCyclicImports(node, new LinkedList<String>());
		
		return ContinueStatus.getInstance(true,true);
	}
	public void setFilename(String filename) {
		this.filename = filename;
	}
	public String getFilename() {
		return filename;
	}
	
}
