#include "CheckCallIsAnswered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckCallIsAnswered::CheckCallIsAnsweredId = "UE_CHECK_CALL_IS_ANSWERED";

CheckCallIsAnswered::CheckCallIsAnswered()
{
	m_successor.reset();
}

CheckCallIsAnswered::~CheckCallIsAnswered()
{
  Logger::Instance().LogInfo("CheckCallIsAnswered::~CheckCallIsAnswered");
  m_successor.reset();
}

int CheckCallIsAnswered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckCallIsAnswered::CheckCallIsAnsweredId)
  {
    ss << "CheckCallIsAnswered::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckCallIsAnswered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckCallIsAnswered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

