#include "DissectorFactory.h"

#include "EthernetDissector.h"
#include "IpDissector.h"
#include "UdpDissector.h"
#include "TcpDissector.h"
#include "SipDissector.h"

DissectorFactory::DissectorFactory() {
  Register("Ethernet", new EthernetDissector);
  Register("IP", new IpDissector);
  Register("UDP", new UdpDissector);
  Register("TCP", new TcpDissector);
  Register("SIP", new SipDissector);
}

DissectorFactory::~DissectorFactory() {

}

