/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class KeyManager
implements Serializable {
    private HashMap keyMap = new HashMap(10);
    private transient WeakHashMap docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration config) {
        this.registerIdrefKey(config);
    }

    private void registerIdrefKey(Configuration config) {
        IdrefTest idref = IdrefTest.getInstance();
        StringFn sf = (StringFn)SystemFunction.makeSystemFunction("string", new Expression[]{new ContextItemExpression()});
        StringLiteral regex = new StringLiteral("\\s+");
        Tokenize use = (Tokenize)SystemFunction.makeSystemFunction("tokenize", new Expression[]{sf, regex});
        KeyDefinition key = new KeyDefinition(idref, use, null, null);
        key.setIndexedItemType(BuiltInAtomicType.STRING);
        try {
            this.addKeyDefinition(StandardNames.getStructuredQName(562), key, config);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public void preRegisterKeyDefinition(StructuredQName keyName) {
        KeyDefinitionSet keySet = (KeyDefinitionSet)this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
    }

    public void addKeyDefinition(StructuredQName keyName, KeyDefinition keydef, Configuration config) throws XPathException {
        KeyDefinitionSet keySet = (KeyDefinitionSet)this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
        keySet.addKeyDefinition(keydef);
        boolean backwardsCompatible = keySet.isBackwardsCompatible();
        if (backwardsCompatible) {
            List v = keySet.getKeyDefinitions();
            for (int i = 0; i < v.size(); ++i) {
                KeyDefinition kd = (KeyDefinition)v.get(i);
                kd.setBackwardsCompatible(true);
                if (kd.getBody().getItemType(config.getTypeHierarchy()).equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter exp = new AtomicSequenceConverter(kd.getBody(), BuiltInAtomicType.STRING);
                kd.setBody(exp);
            }
        }
    }

    public KeyDefinitionSet getKeyDefinitionSet(StructuredQName qName) {
        return (KeyDefinitionSet)this.keyMap.get(qName);
    }

    private synchronized HashMap buildIndex(KeyDefinitionSet keySet, BuiltInAtomicType itemType, Set foundItemTypes, DocumentInfo doc, XPathContext context) throws XPathException {
        List definitions = keySet.getKeyDefinitions();
        HashMap index = new HashMap(100);
        for (int k = 0; k < definitions.size(); ++k) {
            this.constructIndex(doc, index, (KeyDefinition)definitions.get(k), itemType, foundItemTypes, context, k == 0);
        }
        return index;
    }

    private void constructIndex(DocumentInfo doc, HashMap index, KeyDefinition keydef, BuiltInAtomicType soughtItemType, Set foundItemTypes, XPathContext context, boolean isFirst) throws XPathException {
        Item item;
        PatternFinder match = keydef.getMatch();
        XPathContextMajor xc = context.newContext();
        xc.setOrigin(keydef);
        SlotManager map = keydef.getStackFrameMap();
        if (map != null) {
            xc.openStackFrame(map);
        }
        SequenceIterator iter = match.selectNodes(doc, xc);
        while ((item = iter.next()) != null) {
            this.processKeyNode((NodeInfo)item, soughtItemType, foundItemTypes, keydef, index, xc, isFirst);
        }
    }

    private void processKeyNode(NodeInfo curr, BuiltInAtomicType soughtItemType, Set foundItemTypes, KeyDefinition keydef, HashMap index, XPathContext xc, boolean isFirst) throws XPathException {
        AtomicValue item;
        AxisIterator si = SingleNodeIterator.makeIterator(curr);
        si.next();
        xc.setCurrentIterator(si);
        StringCollator collation = keydef.getCollation();
        SequenceIterable use = keydef.getUse();
        SequenceIterator useval = use.iterate(xc);
        while ((item = (AtomicValue)useval.next()) != null) {
            Object val;
            BuiltInAtomicType actualItemType = item.getPrimitiveType();
            if (foundItemTypes != null) {
                foundItemTypes.add(actualItemType);
            }
            if (!Type.isComparable(actualItemType, soughtItemType, false)) {
                if (keydef.isStrictComparison()) {
                    XPathException de = new XPathException("Cannot compare " + soughtItemType + " to " + actualItemType + " using 'eq'");
                    de.setErrorCode("XPTY0004");
                    throw de;
                }
                if (keydef.isConvertUntypedToOther() && actualItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    item = item.convert(soughtItemType, true, xc).asAtomic();
                } else if (!keydef.isConvertUntypedToOther() || !soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) continue;
            }
            if (soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || soughtItemType.equals(BuiltInAtomicType.STRING) || soughtItemType.equals(BuiltInAtomicType.ANY_URI)) {
                val = collation == null ? item.getStringValue() : collation.getCollationKey(item.getStringValue());
            } else {
                if (item.isNaN()) break;
                try {
                    AtomicValue av = item.convert(soughtItemType, true, xc).asAtomic();
                    val = av.getXPathComparable(false, collation, xc);
                }
                catch (XPathException err) {
                    break;
                }
            }
            ArrayList<NodeInfo> nodes = (ArrayList<NodeInfo>)index.get(val);
            if (nodes == null) {
                nodes = new ArrayList<NodeInfo>(4);
                index.put(val, nodes);
                nodes.add(curr);
                continue;
            }
            if (isFirst) {
                if (nodes.get(nodes.size() - 1) == curr) continue;
                nodes.add(curr);
                continue;
            }
            LocalOrderComparer comparer = LocalOrderComparer.getInstance();
            for (int i = 0; i < nodes.size(); ++i) {
                int d = comparer.compare(curr, (NodeInfo)nodes.get(i));
                if (d > 0) continue;
                if (d != 0) {
                    nodes.add(i, curr);
                }
                return;
            }
            nodes.add(curr);
        }
    }

    public SequenceIterator selectByKey(StructuredQName keyName, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        KeyDefinitionSet keyDef = this.getKeyDefinitionSet(keyName);
        if (keyDef == null) {
            throw new XPathException("Key " + keyName.getDisplayName() + " has not been defined");
        }
        return this.selectByKey(keyDef, doc, soughtValue, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceIterator selectByKey(KeyDefinitionSet keySet, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        HashMap indexList;
        HashMap index;
        if (soughtValue == null) {
            return EmptyIterator.getInstance();
        }
        List definitions = keySet.getKeyDefinitions();
        KeyDefinition definition = (KeyDefinition)definitions.get(0);
        StringCollator collation = definition.getCollation();
        if (keySet.isBackwardsCompatible()) {
            soughtValue = soughtValue.convert(BuiltInAtomicType.STRING, true, context).asAtomic();
        } else {
            BuiltInAtomicType itemType = soughtValue.getPrimitiveType();
            if (itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(BuiltInAtomicType.DECIMAL) || itemType.equals(BuiltInAtomicType.FLOAT)) {
                soughtValue = new DoubleValue(((NumericValue)soughtValue).getDoubleValue());
            }
        }
        HashSet foundItemTypes = null;
        AtomicValue value = soughtValue;
        if (soughtValue instanceof UntypedAtomicValue && definition.isConvertUntypedToOther()) {
            BuiltInAtomicType useType = definition.getIndexedItemType();
            if (useType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                foundItemTypes = new HashSet(10);
                useType = BuiltInAtomicType.STRING;
            }
            value = soughtValue.convert(useType, true, context).asAtomic();
        }
        int keySetNumber = keySet.getKeySetNumber();
        BuiltInAtomicType itemType = value.getPrimitiveType();
        DocumentInfo documentInfo = doc;
        synchronized (documentInfo) {
            Object indexObject = this.getIndex(doc, keySetNumber, itemType);
            if (indexObject instanceof String) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            index = (HashMap)indexObject;
            if (index == null) {
                this.putIndex(doc, keySetNumber, itemType, "Under Construction", context);
                index = this.buildIndex(keySet, itemType, foundItemTypes, doc, context);
                this.putIndex(doc, keySetNumber, itemType, index, context);
                if (foundItemTypes != null) {
                    Iterator f = foundItemTypes.iterator();
                    while (f.hasNext()) {
                        BuiltInAtomicType t = (BuiltInAtomicType)f.next();
                        if (t.equals(BuiltInAtomicType.STRING)) continue;
                        this.putIndex(doc, keySetNumber, t, "Under Construction", context);
                        index = this.buildIndex(keySet, t, null, doc, context);
                        this.putIndex(doc, keySetNumber, t, index, context);
                    }
                }
            }
        }
        if (foundItemTypes == null) {
            ArrayList nodes = (ArrayList)index.get(KeyManager.getCollationKey(value, itemType, collation, context));
            if (nodes == null) {
                return EmptyIterator.getInstance();
            }
            return new ListIterator(nodes);
        }
        LookaheadIterator result = null;
        WeakReference ref = (WeakReference)this.docIndexes.get(doc);
        if (ref != null && (indexList = (HashMap)ref.get()) != null) {
            Iterator i = indexList.keySet().iterator();
            while (i.hasNext()) {
                ArrayList nodes;
                long key = (Long)i.next();
                if (key >> 32 != (long)keySetNumber) continue;
                int typefp = (int)key;
                BuiltInAtomicType type = (BuiltInAtomicType)BuiltInType.getSchemaType(typefp);
                Object indexObject2 = this.getIndex(doc, keySetNumber, type);
                if (indexObject2 instanceof String) {
                    XPathException de = new XPathException("Key definition is circular");
                    de.setXPathContext(context);
                    de.setErrorCode("XTDE0640");
                    throw de;
                }
                HashMap index2 = (HashMap)indexObject2;
                if (index2.isEmpty() || (nodes = (ArrayList)index2.get(KeyManager.getCollationKey(value = soughtValue.convert(type, true, context).asAtomic(), type, collation, context))) == null) continue;
                if (result == null) {
                    result = new ListIterator(nodes);
                    continue;
                }
                result = new UnionEnumeration(result, new ListIterator(nodes), LocalOrderComparer.getInstance());
            }
        }
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        return result;
    }

    private static Object getCollationKey(AtomicValue value, BuiltInAtomicType itemType, StringCollator collation, XPathContext context) throws XPathException {
        Object val = itemType.equals(BuiltInAtomicType.STRING) || itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || itemType.equals(BuiltInAtomicType.ANY_URI) ? (collation == null ? value.getStringValue() : collation.getCollationKey(value.getStringValue())) : value.getXPathComparable(false, collation, context);
        return val;
    }

    private synchronized void putIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, Object index, XPathContext context) {
        HashMap indexList;
        WeakReference indexRef;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((indexRef = (WeakReference)this.docIndexes.get(doc)) == null || indexRef.get() == null) {
            indexList = new HashMap(10);
            context.getController().setUserData(doc, "key-index-list", indexList);
            this.docIndexes.put(doc, new WeakReference<HashMap>(indexList));
        } else {
            indexList = (HashMap)indexRef.get();
        }
        indexList.put(new Long((long)keyFingerprint << 32 | (long)itemType.getFingerprint()), index);
    }

    private synchronized Object getIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType) {
        WeakReference ref;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((ref = (WeakReference)this.docIndexes.get(doc)) == null) {
            return null;
        }
        HashMap indexList = (HashMap)ref.get();
        if (indexList == null) {
            return null;
        }
        return indexList.get(new Long((long)keyFingerprint << 32 | (long)itemType.getFingerprint()));
    }

    public void clearDocumentIndexes(DocumentInfo doc) {
        this.docIndexes.remove(doc);
    }

    public int getNumberOfKeyDefinitions() {
        return this.keyMap.size();
    }

    public void explainKeys(ExpressionPresenter out) {
        if (this.keyMap.size() < 2) {
            return;
        }
        out.startElement("keys");
        Iterator keyIter = this.keyMap.keySet().iterator();
        while (keyIter.hasNext()) {
            StructuredQName qName = (StructuredQName)keyIter.next();
            List list = ((KeyDefinitionSet)this.keyMap.get(qName)).getKeyDefinitions();
            for (int i = 0; i < list.size(); ++i) {
                KeyDefinition kd = (KeyDefinition)list.get(i);
                out.startElement("key");
                out.emitAttribute("name", qName.getDisplayName());
                out.emitAttribute("match", kd.getMatch().toString());
                if (kd.getUse() instanceof Expression) {
                    ((Expression)kd.getUse()).explain(out);
                }
                out.endElement();
            }
        }
        out.endElement();
    }
}

