/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunction {
    private transient AtomicComparer atomicComparer;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        if (this.stringCollator != null) {
            int type = this.argument[0].getItemType(visitor.getConfiguration().getTypeHierarchy()).getPrimitiveType();
            this.atomicComparer = AtomicSortComparer.makeSortComparer(this.stringCollator, type, visitor.getStaticContext().makeEarlyEvaluationContext());
        }
    }

    public AtomicComparer getAtomicComparer() {
        return this.atomicComparer;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicComparer comp = this.atomicComparer;
        if (comp == null) {
            int type = this.argument[0].getItemType(context.getConfiguration().getTypeHierarchy()).getPrimitiveType();
            comp = this.makeAtomicSortComparer(type, context);
        } else {
            comp = comp.provideContext(context);
        }
        SequenceIterator iter = this.argument[0].iterate(context);
        return new DistinctIterator(iter, comp);
    }

    private AtomicComparer makeAtomicSortComparer(int type, XPathContext context) throws XPathException {
        StringCollator collator = this.getCollator(1, context);
        return AtomicSortComparer.makeSortComparer(collator, type, context);
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicComparer comparer;
        private int position;
        private AtomicValue current;
        private HashSet lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator base, AtomicComparer comparer) {
            this.base = base;
            this.comparer = comparer;
            this.position = 0;
        }

        public Item next() throws XPathException {
            AtomicValue nextBase;
            ComparisonKey key;
            do {
                if ((nextBase = (AtomicValue)this.base.next()) != null) continue;
                this.current = null;
                this.position = -1;
                return null;
            } while (this.lookup.contains(key = this.comparer.getComparisonKey(nextBase)));
            this.lookup.add(key);
            this.current = nextBase;
            ++this.position;
            return nextBase;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new DistinctIterator(this.base.getAnother(), this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

