#ifndef TriggerCommandsGUI_CheckCallIsInitialized_h
#define TriggerCommandsGUI_CheckCallIsInitialized_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class CheckCallIsInitialized
 * \brief This class provides processing for UE_CHECK_CALL_IS_INITIALIZED Trigger command.
 */
class CheckCallIsInitialized : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckCallIsInitializedId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckCallIsInitialized();
  CheckCallIsInitialized(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckCallIsInitialized();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_CheckCallIsInitialized_h

