/**
 * @file GenericCapture.cpp
 * @author Tomas Urban
 * @version 0.3
 * @date 23/07/2009
 */
#include "GenericCapture.h"
#include "Logger/Logger.h"

GenericCapture::GenericCapture() :
	m_pDispatch(0)
{
	m_startPoint.tv_sec = 0;
	m_startPoint.tv_usec = 0;
	m_offset.tv_sec = 0;
	m_offset.tv_usec = 0;
	m_timestamp.tv_sec = 0;
	m_timestamp.tv_usec = 0;
}

GenericCapture::~GenericCapture(void)
{
	
}

void GenericCapture::UpdateTimestamp()
{
	m_timestamp.tv_sec = m_startPoint.tv_sec + m_offset.tv_sec;
	m_timestamp.tv_usec = m_startPoint.tv_usec + m_offset.tv_usec;
	int nSec = m_timestamp.tv_usec / 1000000;
	if (nSec > 0)
	{
		m_timestamp.tv_sec += nSec;
		m_timestamp.tv_usec -= nSec * 1000000;
	}
}

void GenericCapture::SetStartPoint(struct timeval timestamp)
{
	m_startPoint = timestamp;
	UpdateTimestamp();
}

void GenericCapture::SetStartOffset(struct timeval offset) 
{ 
	m_offset = offset;
	UpdateTimestamp();
}

void GenericCapture::ProcessCapturedData(CapturedData * pData)
{
	if (!m_pDispatch)
		return;
	timeval msgTime = pData->GetTimestamp();
	if (msgTime.tv_sec > m_timestamp.tv_sec ||
		msgTime.tv_sec == m_timestamp.tv_sec && msgTime.tv_usec >= m_timestamp.tv_usec)
	{
		pData->SetCaptureType(GetCaptureType());
		m_pDispatch->DispatchData(pData);
	}
	else
		Logger::Instance().LogDebug("Captured message discarded (older than start point)");
}

bool GenericCapture::SetCaptureFile(const std::string sFile) 
{ 
	return sFile.length() == 0; 
}
