#include "Register.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string Register::RegisterId = "UE_REGISTRATION";

Register::Register()
{
	m_successor.reset();
}

Register::~Register()
{
  Logger::Instance().LogInfo("Register::~Register");
  m_successor.reset();
}

int Register::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == Register::RegisterId)
  {
    ss << "Register::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "Register::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void Register::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

