#include "CheckIsRegistered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckIsRegistered::CheckIsRegisteredId = "UE_CHECK_IS_REGISTER";

CheckIsRegistered::CheckIsRegistered()
{
  m_successor.reset();
}

CheckIsRegistered::CheckIsRegistered(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckIsRegistered();
  m_eutIface = eutIface;
}

CheckIsRegistered::~CheckIsRegistered()
{
  Logger::Instance().LogInfo("CheckIsRegistered::~CheckIsRegistered");
  m_successor.reset();
}

int CheckIsRegistered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckIsRegistered::CheckIsRegisteredId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckIsRegistered::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckIsRegistered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckIsRegistered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

