package org.etsi.t3d.config;

import org.etsi.common.configuration.ConfigurationProfile;

public class DocumentationProfile extends ConfigurationProfile {

	private CommentTagsConfiguration commentTagsConfiguration = new CommentTagsConfiguration();
	
	private boolean includeConstructBody = true;
	private boolean hideConstructBody = false;
	private boolean showOriginalT3DocTags = false;
	private boolean checkUndocumentedParameters = true;
	private boolean checkFunctionDescTagsRequired = false;

	private boolean checkConsistentTagUsage = true;
	private boolean checkIdenticalDescriptionTags = true;
	private boolean checkCyclicImports = true;
	
	private String cssFile = System.getenv("T3D_HOME")+"/css/doc.css";
	private String jsFile = System.getenv("T3D_HOME")+"/js/doc.js";
	private String xsltFileHTML = System.getenv("T3D_HOME")+"/xslt/html.xsl";
	private String xsltFileImport = System.getenv("T3D_HOME")+"/xslt/html_import.xsl";

	private String outputDirectory = "DOCUMENTATION";

	public String getJsFile() {
		return jsFile;
	}

	public void setJsFile(String jsFile) {
		this.jsFile = jsFile;
	}

	public String getOutputDirectory() {
		return outputDirectory;
	}

	public void setOutputDirectory(String outputDirectory) {
		this.outputDirectory = outputDirectory;
	}

	public void setCssFile(String cssFile) {
		this.cssFile = cssFile;
	}

	public String getCssFile() {
		return cssFile;
	}

	public void setXsltFileHTML(String xsltFileHTML) {
		this.xsltFileHTML = xsltFileHTML;
	}
	
	public String getXsltFileHTML() {
		return xsltFileHTML;
	}

	public void setIncludeConstructBody(boolean includeConstructBody) {
		this.includeConstructBody = includeConstructBody;
	}

	public boolean isIncludeConstructBody() {
		return includeConstructBody;
	}

	public boolean isHideConstructBody() {
		return hideConstructBody && includeConstructBody;
	}

	public void setHideConstructBody(boolean hideConstructBody) {
		this.hideConstructBody = hideConstructBody;
	}

	public boolean isCheckUndocumentedParameters() {
		return checkUndocumentedParameters;
	}

	public void setCheckUndocumentedParameters(boolean checkUndocumentedParameters) {
		this.checkUndocumentedParameters = checkUndocumentedParameters;
	}

	public boolean isShowOriginalT3DocTags() {
		return showOriginalT3DocTags;
	}

	public void setShowOriginalT3DocTags(boolean showOriginalT3DocTags) {
		this.showOriginalT3DocTags = showOriginalT3DocTags;
	}

	public boolean isCheckCyclicImports() {
		return checkCyclicImports;
	}

	public void setCheckCyclicImports(boolean checkCyclicImports) {
		this.checkCyclicImports = checkCyclicImports;
	}

	public String getXsltFileImport() {
		return xsltFileImport;
	}

	public void setXsltFileImport(String xsltFileImport) {
		this.xsltFileImport = xsltFileImport;
	}

	public void setCheckConsistentTagUsage(boolean checkConsistentTagUsage) {
		this.checkConsistentTagUsage = checkConsistentTagUsage;
	}

	public boolean isCheckConsistentTagUsage() {
		return checkConsistentTagUsage;
	}

	public void setCheckIdenticalDescriptionTags(
			boolean checkIdenticalDescriptionTags) {
		this.checkIdenticalDescriptionTags = checkIdenticalDescriptionTags;
	}

	public boolean isCheckIdenticalDescriptionTags() {
		return checkIdenticalDescriptionTags;
	}

	public void setCommentTagConfiguration(CommentTagsConfiguration commentTagsConfiguration) {
		this.commentTagsConfiguration = commentTagsConfiguration;
	}

	public CommentTagsConfiguration getCommentTagsConfiguration() {
		return commentTagsConfiguration;
	}
	public boolean isCheckFunctionDescTagsRequired() {
		return checkFunctionDescTagsRequired;
	}

	public void setCheckFunctionDescTagsRequired(
			boolean checkFunctionDescTagsRequired) {
		this.checkFunctionDescTagsRequired = checkFunctionDescTagsRequired;
	}

}
