/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.xqj.SaxonXQItemType;

public class SaxonXQStaticContext
implements XQStaticContext {
    private Configuration config;
    private int bindingMode = 0;
    private int holdability = 1;
    private int scrollability = 1;
    private Map namespaces = new HashMap();
    private String baseURI = "";
    boolean preserveBoundarySpace = true;
    boolean constructionModeIsPreserve = false;
    boolean inheritNamespaces = true;
    boolean preserveNamespaces = true;
    boolean emptyLeast = true;
    boolean isOrdered = true;
    SaxonXQItemType contextItemStaticType = null;
    String defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    String defaultElementNamespace = "";
    String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";

    public SaxonXQStaticContext(Configuration config) {
        this.config = config;
    }

    protected StaticQueryContext getSaxonStaticQueryContext() {
        StaticQueryContext sqc = new StaticQueryContext(this.config);
        sqc.setBaseURI(this.baseURI);
        sqc.setConstructionMode(this.constructionModeIsPreserve ? 3 : 4);
        sqc.setDefaultElementNamespace(this.defaultElementNamespace);
        sqc.setDefaultFunctionNamespace(this.defaultFunctionNamespace);
        sqc.setEmptyLeast(this.emptyLeast);
        sqc.setInheritNamespaces(this.inheritNamespaces);
        sqc.setPreserveBoundarySpace(this.preserveBoundarySpace);
        sqc.setPreserveNamespaces(this.preserveNamespaces);
        if (this.contextItemStaticType != null) {
            sqc.setRequiredContextItemType(this.contextItemStaticType.getSaxonItemType());
        }
        Iterator iter = this.namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = (String)this.namespaces.get(prefix);
            sqc.declareNamespace(prefix, uri);
        }
        return sqc;
    }

    public void declareNamespace(String prefix, String uri) throws XQException {
        this.checkNotNull(prefix);
        this.checkNotNull(uri);
        if (uri.length() == 0) {
            this.namespaces.remove(prefix);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getBindingMode() {
        return this.bindingMode;
    }

    public int getBoundarySpacePolicy() {
        return this.preserveBoundarySpace ? 1 : 2;
    }

    public int getConstructionMode() {
        return this.constructionModeIsPreserve ? 1 : 2;
    }

    public XQItemType getContextItemStaticType() {
        return this.contextItemStaticType;
    }

    public int getCopyNamespacesModeInherit() {
        return this.inheritNamespaces ? 1 : 2;
    }

    public int getCopyNamespacesModePreserve() {
        return this.preserveNamespaces ? 1 : 2;
    }

    public String getDefaultCollation() {
        return this.defaultCollationName;
    }

    public String getDefaultElementTypeNamespace() {
        return this.defaultElementNamespace;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public int getDefaultOrderForEmptySequences() {
        return this.emptyLeast ? 2 : 1;
    }

    public String[] getNamespacePrefixes() {
        String[] result = new String[this.namespaces.size()];
        Iterator iter = this.namespaces.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            iter.hasNext();
            result[i] = (String)iter.next();
        }
        return result;
    }

    public String getNamespaceURI(String prefix) throws XQException {
        this.checkNotNull(prefix);
        String uri = (String)this.namespaces.get(prefix);
        if (uri == null) {
            throw new XQException("Unknown prefix");
        }
        return uri;
    }

    public int getOrderingMode() {
        return this.isOrdered ? 1 : 2;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public int getQueryLanguageTypeAndVersion() {
        return 1;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public int getScrollability() {
        return this.scrollability;
    }

    public void setBaseURI(String baseUri) throws XQException {
        this.checkNotNull(baseUri);
        this.baseURI = baseUri;
    }

    public void setBindingMode(int bindingMode) throws XQException {
        switch (bindingMode) {
            case 0: 
            case 1: {
                this.bindingMode = bindingMode;
                break;
            }
            default: {
                throw new XQException("Invalid value for binding mode - " + bindingMode);
            }
        }
    }

    public void setBoundarySpacePolicy(int policy) throws XQException {
        switch (policy) {
            case 1: {
                this.preserveBoundarySpace = true;
                break;
            }
            case 2: {
                this.preserveBoundarySpace = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for boundary space policy - " + policy);
            }
        }
    }

    public void setConstructionMode(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.constructionModeIsPreserve = true;
                break;
            }
            case 2: {
                this.constructionModeIsPreserve = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for construction mode - " + mode);
            }
        }
    }

    public void setContextItemStaticType(XQItemType contextItemType) {
        this.contextItemStaticType = (SaxonXQItemType)contextItemType;
    }

    public void setCopyNamespacesModeInherit(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.inheritNamespaces = true;
                break;
            }
            case 2: {
                this.inheritNamespaces = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for namespaces inherit mode - " + mode);
            }
        }
    }

    public void setCopyNamespacesModePreserve(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.preserveNamespaces = true;
                break;
            }
            case 2: {
                this.preserveNamespaces = false;
                break;
            }
            default: {
                throw new XQException("Invalid value for namespaces preserve mode - " + mode);
            }
        }
    }

    public void setDefaultCollation(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultCollationName = uri;
    }

    public void setDefaultElementTypeNamespace(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(String uri) throws XQException {
        this.checkNotNull(uri);
        this.defaultFunctionNamespace = uri;
    }

    public void setDefaultOrderForEmptySequences(int order) throws XQException {
        switch (order) {
            case 1: {
                this.emptyLeast = false;
                break;
            }
            case 2: {
                this.emptyLeast = true;
                break;
            }
            default: {
                throw new XQException("Invalid value for default order for empty sequences - " + order);
            }
        }
    }

    public void setOrderingMode(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.isOrdered = true;
                break;
            }
            case 2: {
                this.isOrdered = false;
                break;
            }
            default: {
                throw new XQException("Invalid ordering mode - " + mode);
            }
        }
    }

    public void setQueryTimeout(int seconds) throws XQException {
        if (seconds < 0) {
            throw new XQException("Query timeout must not be negative");
        }
    }

    public void setHoldability(int holdability) throws XQException {
        switch (holdability) {
            case 1: 
            case 2: {
                this.holdability = holdability;
                break;
            }
            default: {
                throw new XQException("Invalid holdability value - " + holdability);
            }
        }
    }

    public void setQueryLanguageTypeAndVersion(int langtype) throws XQException {
        if (langtype != 1) {
            throw new XQException("XQueryX is not supported");
        }
    }

    public void setScrollability(int scrollability) throws XQException {
        switch (scrollability) {
            case 1: 
            case 2: {
                this.scrollability = scrollability;
                break;
            }
            default: {
                throw new XQException("Invalid scrollability value - " + scrollability);
            }
        }
    }

    protected void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

