#ifndef TriggerCommandsOffLine_CheckNewMediaRemoved_h
#define TriggerCommandsOffLine_CheckNewMediaRemoved_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class CheckNewMediaRemoved
 * \brief This class provides processing for UE_CHECK_NEW_MEDIA_STREAM_IS_REMOVED Trigger command.
 */
class CheckNewMediaRemoved : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckNewMediaRemovedId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckNewMediaRemoved();
  ~CheckNewMediaRemoved();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_CheckNewMediaRemoved_h

