#ifndef TCP_DISSECTOR_H
#define TCP_DISSECTOR_H

#include "Dissector.h"
#include <string>

class TcpDissector : public Dissector {

 public:
  TcpDissector();
  virtual ~TcpDissector();
  virtual TcpDissector * Clone() const;
  virtual bool Dissect(const unsigned char * pData, const ssize_t nDataLen);
  virtual bool NeedReassembly() const;
  virtual bool Reassemble(Dissector * pDissector, ProtocolInfo * pProtocolInfo);
  virtual const EProtocolType GetUpperLayerType() const;

 private:
  struct TcpHeader {
    unsigned short srcPort;          // source port 
    unsigned short destPort;         // destination port 
    unsigned int   sequence;         // sequence number - 32 bits 
    unsigned int   acknowledge;      // acknowledgement number - 32 bits 
    
    unsigned char  ns   :1;          //Nonce Sum Flag Added in RFC 3540.
    unsigned char  reservedPart1:3;  //according to rfc
    unsigned char  dataOffset:4;     //number of dwords in the TCP header. 
    
    unsigned char  fin  :1;          //Finish Flag
    unsigned char  syn  :1;          //Synchronise Flag
    unsigned char  rst  :1;          //Reset Flag
    unsigned char  psh  :1;          //Push Flag 
    unsigned char  ack  :1;          //Acknowledgement Flag 
    unsigned char  urg  :1;          //Urgent Flag
    
    unsigned char  ecn  :1;          //ECN-Echo Flag
    unsigned char  cwr  :1;          //Congestion Window Reduced Flag
        
    unsigned short window;           // window 
    unsigned short checksum;         // checksum 
    unsigned short urgentPointer;    // urgent pointer 
  };

  TcpHeader * m_tcpHdr;
 protected:
  ProtocolInfoElement * CreateLayerInfo();
};

#endif
