#ifndef TriggerCommandsOffLine_TriggerCommands_h
#define TriggerCommandsOffLine_TriggerCommands_h

#include <boost/shared_ptr.hpp>

#include "Processors/TriggerCommandsStrategy.h"
#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class TriggerCommands
 * \brief This class provides access the the chain of responsability which process Trigger commands.
 */
class TriggerCommands : public Processors::TriggerCommandsStrategy
{
  boost::shared_ptr<Processors::TriggerCommandsImpl> m_successor;

public:
	TriggerCommands();
	~TriggerCommands();
	
public: // Public interface.
  //! SetEutIpInterface.
  /*! Initialize the EUT IP interface.
   * @param eutIface: .EUT IP interface.
   */
  void SetEutIpInterface(boost::shared_ptr<EutIPInterface> eutIface);
  /*! Process the Trigger command message.
   * @param command: trigger command to execute
   * @param params: Comand parameters
   * @return FncRetCode value on success, -1 otherwise.
   */
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_TriggerCommands_h

