#include "DataPort.h"

#include <iostream>

#include "Logger/Logger.h"
#include "LowerTestAdapter.h"

using namespace t3devlib;
using namespace std;

DataPort::DataPort (PortId& portId) 
:Port(portId) {
  Logger::Instance().LogInfo("DataPort::DataPort");
  LowerTestAdapter::Instance().RegisterDataPort(this);  
}

DataPort::~DataPort() {
    Logger::Instance().LogInfo("~DataPort::DataPort");
}

bool DataPort::Map (const PortId& connectedPortId) {

  m_connectedPorts.push_back(&connectedPortId);
  return true; 
} 
 
bool DataPort::Unmap (const PortId& connectedPortId) { 

  //TODO: remove from m_connectedPorts
  return true; 
}

bool DataPort::Send (const ComponentId& from,const Bitstring& bsMsg) {

  return true;
}

const t3devlib::PortId& DataPort::GetConnectedPort(const ComponentId *pComponentId) {
  std::list<const PortId *>::iterator it;
  for(it = m_connectedPorts.begin(); it != m_connectedPorts.end(); it++) {
    if(&((*it)->GetComponentId()) == pComponentId) {
      return **it;
    }
  }
}
