#ifndef  SIPCODETS_H
#define  SIPCODETS_H

#include <t3devlib/t3devlib.h>

namespace t3devlib {
namespace gen {

//
// Implementation of subtypes defined in the module LibSip_SIPTypesAndValues
//

// aliases (subtypes without restrictions)
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, CallidString, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, ContentCoding, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, DeltaSec, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, LanguageTag, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, OptionTag, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, ServerVal, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, PAssertedServiceValue, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, PrivacyValue, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, EventType, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, SubState, Charstring);
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, PMediaAuthValue, Charstring); //HEXDIG "0"-"9", "A"-"F"
T3DEVLIB_BASIC_DEFINITION (LibSip_SIPTypesAndValues, Raw, Charstring);

// subtypes of structured type
// we just handle them by defining an alias to the base class
//
// FIXME: subtypes of structured types is not explicitely allowed in TTCN-3
// 	  is this valid anyway ?
#define PAssertedIDValue Addr_Union
#define PPreferredIDValue Addr_Union

//
// Implementation of enumerated types (not handled by the generator yet)
//

class FieldName : public t3devlib::Enum
{
private:
	static const char* msFields[];
public:
	FieldName() : Enum (msFields) {}

	const char* GetModuleName() const { return "LibSip_SIPTypesAndValues"; }
	const char* GetTypeName() const   { return "FieldName"; }

	void Encode (Buffer& buffer) throw (EncodeError);
	void Decode (Buffer& buffer) throw (DecodeError);
};

class Method : public t3devlib::Enum
{
private:
	static const char* msSipMethods[];
	static const char* msMethodValues[];
public:
	Method() : Enum (msSipMethods) {}

	const char* GetModuleName() const { return "LibSip_SIPTypesAndValues"; }
	const char* GetTypeName() const   { return "Method"; }

	void Encode (Buffer& buffer) throw (EncodeError);
	void Decode (Buffer& buffer) throw (DecodeError);
};

// definition additional attributes for the Addr_Union class
// (included automatically in the generated codec)
#define DEFINITIONS_Addr_Union()	int mPosition;


}} //namespaces

#endif

