#ifndef TriggerCommandsOffLine_CheckCallIsAnswered_h
#define TriggerCommandsOffLine_CheckCallIsAnswered_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class CheckCallIsAnswered
 * \brief This class provides processing for UE_CHECK_CALL_IS_ANSWERED Trigger command.
 */
class CheckCallIsAnswered : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckCallIsAnsweredId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
public:
  CheckCallIsAnswered();
  ~CheckCallIsAnswered();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsOffLine_CheckCallIsAnswered_h

