#include "CheckCallIsInitialized.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckCallIsInitialized::CheckCallIsInitializedId = "UE_CHECK_CALL_IS_INITIALIZED";

CheckCallIsInitialized::CheckCallIsInitialized()
{
	m_successor.reset();
}

CheckCallIsInitialized::CheckCallIsInitialized(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckCallIsInitialized();
  m_eutIface = eutIface;
}

CheckCallIsInitialized::~CheckCallIsInitialized()
{
  Logger::Instance().LogInfo("CheckCallIsInitialized::~CheckCallIsInitialized");
  m_successor.reset();
}

int CheckCallIsInitialized::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckCallIsInitialized::CheckCallIsInitializedId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckCallIsInitialized::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckCallIsInitialized::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckCallIsInitialized::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

