/**
 * @file PCAPOfflineCapture.h
 * This header file defines the PCAPOfflineCapture class.
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#ifndef PCAP_OFFLINE_CAPTURE_H
#define PCAP_OFFLINE_CAPTURE_H

#include "PCAPCapture.h"
/**
 * Class used for reading traffic logs stored in the pcap format.
 */
class PCAPOfflineCapture :
	public PCAPCapture
{

public:
	PCAPOfflineCapture();
	virtual ~PCAPOfflineCapture(void);
	/**
	 * Initializes capturing object. The parameter shall contain a path to the traffic log file.
	 * @param sParams Log file path
	 * @return Operation success
	 */	
	virtual ECaptureInitResult OpenDevice(const std::string sParams);
};

#endif

