#ifndef TriggerCommandsGUI_CheckIsNotRegistered_h
#define TriggerCommandsGUI_CheckIsNotRegistered_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class CheckIsNotRegistered
 * \brief This class provides processing for UE_CHECK_CALL_IS_NOT_REGISTED Trigger command.
 */
class CheckIsNotRegistered : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckIsNotRegisteredId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckIsNotRegistered();
  CheckIsNotRegistered(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckIsNotRegistered();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_CheckIsNotRegistered_h

