#ifndef DataPort_h
#define DataPort_h

#include <t3devlib/t3devlib.h>

class DataPort : public t3devlib::Port
{
 public:
  DataPort(t3devlib::PortId& portId);
  const t3devlib::PortId& GetConnectedPort() const;
  const t3devlib::PortId& GetConnectedPort(const t3devlib::ComponentId *pComponentId);
  ~DataPort();
  
 protected:
  bool Map(const t3devlib::PortId& connectedPortId);
  bool Unmap(const t3devlib::PortId& connectedPortId);
  bool Send(const t3devlib::ComponentId& from, const t3devlib::Bitstring& bsMsg);

 private:
  std::list<const t3devlib::PortId *> m_connectedPorts;
};


#endif //DataPort_h
