/**
 * @file CaptureFactory.cpp
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#include "CaptureFactory.h"
#include "PCAPLiveCapture.h"
#include "PCAPOfflineCapture.h"
#include "Logger/Logger.h"

CaptureFactory::CaptureFactory(void)
{
}

CaptureFactory::~CaptureFactory(void)
{
}

GenericCapture * CaptureFactory::CreateCaptureInstance(ECaptureType captureType,
		ECaptureMode captureMode)
{
	GenericCapture * pInst = NULL;
	std::string s = "Capture instance created: ";
	switch (captureType)
	{
		case ECaptureType_PCAP:
			if (captureMode == ECaptureMode_Live)
			{
				pInst = new PCAPLiveCapture();
				s += "PCAP live";
			}
			else
			{
				pInst = new PCAPOfflineCapture();
				s += "PCAP offline";
			}
			break;
	}
	if (pInst)
		Logger::Instance().LogDebug(s);
	else
		Logger::Instance().LogError("Unknown capture type");
	return pInst;
}
void CaptureFactory::DisposeCaptureInstance(GenericCapture * pInstance)
{
	delete pInstance;
}


