/**
 * @file UEUserGuideClientMessages.h
 * This header file defines simple data message used in communication with the 
 * .UEUserGuide application
 * @author Yann Garcia
 * @version 0.3
 * @date 28/07/2009
 */

#ifndef TriggerCommandsGUI_UEUserGuideClientMessages
#define TriggerCommandsGUI_UEUserGuideClientMessages

#include "Messages/TrafficCaptureMessageId.h"
#include "Messages/TrafficCaptureMessage.h"
#include <vector>

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/**
 * This class describes a merging request. This request is used for merging several pcap files
 * into one. If the operation is successful, the path to the file containing merged data is
 * returned by a subsequent response.
 */
class UEUserGuideClientRequest : public TrafficCaptureMessage
{
private:
  std::string m_sTrigger;
  std::vector<std::string> m_vsParamsList;
protected:
  virtual unsigned int CalculateDataLength();
  virtual void EncodePayload(unsigned int & nOffset);
  virtual bool DecodePayload(const char * pPayload, unsigned int nPayloadLength, unsigned int & nOffset);
public:
  UEUserGuideClientRequest() {}
  virtual ~UEUserGuideClientRequest() {}
  virtual unsigned short GetId() const { return 0x0001; }

  void SetTriggerCommand(const std::string & sTrigger, const std::vector<std::string> & vsParamsList);
};

/**
 * This class describes a reply to a merging request.
 */
class UEUserGuideClientReply : public CommonReplyMessage
{
protected:
  virtual unsigned int CalculateDataLength();
  virtual void EncodePayload(unsigned int & nOffset);
  virtual bool DecodePayload(const char * pPayload, unsigned int nPayloadLength, unsigned int & nOffset);
public:
  UEUserGuideClientReply() {}
  virtual ~UEUserGuideClientReply() {}
  virtual unsigned short GetId() const { return 0x0002; }
};

} } } // namespaces

#endif // TriggerCommandsGUI_UEUserGuideClientMessages
