#ifndef STF370_PacketFilterExpression_h
#define STF370_PacketFilterExpression_h

#include <string>
#include "PacketDissector.h"
 
using namespace std;

enum ExpressionOperator {
  EO_NONE,
  EO_EQUAL,
  EO_DIFFERENT
};
	
class PacketFilterExpression {

 public:
  PacketFilterExpression(const string& sExpression = "");
  virtual ~PacketFilterExpression();
  const string& GetExpression() const;
  bool Match(const PacketDissector& packet) const;

 private:
  HeaderId m_headerId;
  FieldId m_fieldId;
  string m_leftPart;
  string m_value;
  ExpressionOperator m_operator;
};

#endif
