package org.etsi.t3d.visitor;

import java.util.ArrayList;
import java.util.LinkedList;

import org.etsi.t3d.DependencyPrinter;
import org.etsi.t3d.exceptions.TTCN3BehaviorException;

import de.ugoe.cs.swe.trex.core.analyzer.rfparser.ASTUtil;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.LocationAST;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.TTCN3ParserTokenTypes;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.symboltable.EnumSymbol;
import de.ugoe.cs.swe.trex.core.analyzer.rfparser.symboltable.Symbol;

public class DependencyVisitor extends AbstractVisitor {
	
	private DependencyPrinter dependencyPrinter;

	public DependencyVisitor(DependencyPrinter dependencyPrinter) {
		this.dependencyPrinter = dependencyPrinter;
	}
	@Override
	public void finish() {
	}

	@Override
	public void init() {
	}
	
	/**
	 * Extracts referenced identifiers from within a module definition subtree
	 * TODO: filter out predefined functions
	 * @param moduleDefinitionNode - A module definition node
	 * @return - A list of referenced identifier nodes, excluding the identifier nodes of the module definition itself; if node is not of type ModuleDefintion, an empty list is returned instead
	 */
	//TODO: This may have to be deprecated
	private static LinkedList<LocationAST> getReferencedIdentifierNodes(LocationAST moduleDefinitionNode){
		if (moduleDefinitionNode.getType()!=TTCN3ParserTokenTypes.ModuleDefinition) {
			return new LinkedList<LocationAST>();
		}
		LinkedList<LocationAST> identifierNodes = ASTUtil.findTypeNodes(moduleDefinitionNode, TTCN3ParserTokenTypes.Identifier);
		ArrayList<LocationAST> moduleDefinitionIdentifierNodes = LocationAST.getModuleDefinitionIdentifiersList(moduleDefinitionNode);
		identifierNodes.removeAll(moduleDefinitionIdentifierNodes);
		//TODO: exclude predefined functions
		return identifierNodes;
	}
	
	public ContinueStatus visitModuleDefinition(LocationAST node) throws TTCN3BehaviorException {
		dependencyPrinter.newElement(node);
		return ContinueStatus.getInstance(true,true);
	}


	
}
