package org.etsi.t3d;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;


public class T3DLoggingInterface {
	//TODO: reuse statistics
	private PrintStream stream;
	private int LOG_LEVEL = 1;
	private String[] messageTypes = {"Information", "WARNING", "ERROR"};
	private boolean firstFile = true;
	private LinkedList<String> files = new LinkedList<String>();
	private LinkedList<String> filesWithoutErrorsWarnings = new LinkedList<String>();
	
	
	public T3DLoggingInterface(){
	}
	
	private class T3DLogEvent{
		private int level;
		private int type; // 0 = info, 1 = warning, 2 = error
		private String event;
		private String lines;
		
		public T3DLogEvent(int level, int type, String event, String lines) {
			this.level = level;
			this.type = type;
			this.event = event;
			this.lines = lines;
		}
		
		public String toString(){
			return "<" + messageTypes[type].toLowerCase() + " level =\""+ level +"\" lines=\"" + lines.trim() + "\">" + event + "</" + messageTypes[type].toLowerCase() + ">";
		}
	}


	public void printLog(int LEVEL, String filename, int startLine, int endLine, int type, String output) {
		if (LEVEL <= this.getLOG_LEVEL()) {
			String lines;
			if (startLine >= endLine) {
				lines = " " + startLine;
			} else {
				lines = " " + startLine + "-" + endLine;
			}
			String log = "    " + filename + ": " + lines + ": " + messageTypes[type] + ": " + output;
			System.out.println(log);
			setEvent(LEVEL, type, output, lines);
			if(type == 1 || type == 2)
				filesWithoutErrorsWarnings.remove(filename);
		}
	}

	
	private void setEvent(int level, int type, String event, String lines){
		writeStream("\n\t\t" + new T3DLogEvent(level, type, event, lines));
	}
	
	public void setLOG_LEVEL(int lOG_LEVEL) {
		LOG_LEVEL = lOG_LEVEL;
	}


	public int getLOG_LEVEL() {
		return LOG_LEVEL;
	}
	
	public void setCurrentTTCN3File(String currentTTCN3File) {
		if(!firstFile)
			writeStream("\n\t</file>");
		else
			firstFile = false;
		writeStream("\n\t<file path=\"" + currentTTCN3File + "\">");
		files.add(currentTTCN3File);
		filesWithoutErrorsWarnings.add(currentTTCN3File);
	}
	
	private void writeStream(String content){
		stream.print(content);
	}
	
	public void finishXML(){
			writeStream("\n\t</file>");
		writeStream("\n</t3dlog>");
		
		System.out.println("\tINFORMATION:");
		System.out.println("\t Files parsed:");
		for(String file : files)
			System.out.println("\t  " + file);
		System.out.println("\t Files processed without errors/warnings:");
		for(String file : filesWithoutErrorsWarnings)
			System.out.println("\t  " + file);
		System.out.println("\t Files processed with errors/warnings:");
		for(String file : files)
			if(!filesWithoutErrorsWarnings.contains(file))
			System.out.println("\t  " + file);
	}
	
	public void setXMLPath(String xmlpath){
		FileOutputStream file;
		try {
			file = new FileOutputStream(xmlpath);
			stream = new PrintStream(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		writeStream("\n<t3dlog t3dversion=\"" + T3D.versionNumber + "\">");		
	}
}
