; T3D Installer
;-----------------------------------------------------------------------------------------------------------------------------

!define PRODUCT_NAME "T3D"
!define AppName "T3D"
!define AppVersion "1.0"
!define ShortName "T3D"
!define Vendor "Software Engineering for Distributed Systems Group, University of G�ttingen"
!define JRE_VERSION "1.6"
!define JRE_URL "http://javadl.sun.com/webapps/download/AutoDL?BundleId=26223"
!define ALL_USERS

LangString ConfirmUninstall ${LANG_ENGLISH} "All existing \
files and folders under the $(^Name) installation directory \
'$INSTDIR' will be removed.$\r$\nThis includes any files and folders \
that have since been added after the installation of \
$(^Name).$\r$\n$\r$\nAre you sure you wish to continue?"

!include "MUI2.nsh"
!include "StrFunc.nsh"
!include "EnvVarUpdate.nsh"
!include "WriteEnvStr.nsh"

Name "T3D"
OutFile "t3d-install-32bit.exe"

InstallDir $PROGRAMFILES\ETSI\T3D
InstallDirRegKey HKLM "Software\ETSI\T3D" "Install_Dir"

RequestExecutionLevel admin

!define MUI_ABORTWARNING

!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section ""
  Call DetectJRE
SectionEnd

;-----------------------------------------------------------------------------------------------------------------------------
; The stuff to install
Section "T3D (required)"
  SectionIn RO
  SetOutPath $INSTDIR
  File "..\dist\t3d.bat"
  File "..\doc\t3d-documentation.pdf"
  SetOutPath $INSTDIR\css
  File "..\css\*.css"
  SetOutPath $INSTDIR\js
  File "..\js\*.js"
  SetOutPath $INSTDIR\xsd
  File "..\xsd\*.*"
  SetOutPath $INSTDIR\xslt
  File "..\xslt\*.xsl"
  SetOutPath $INSTDIR\lib
  File /r "..\dist\lib\*.jar"
  SetOutPath $INSTDIR
  
  ;CreateDirectory $APPDATA\T3D
  
  WriteRegStr HKLM SOFTWARE\ETSI\T3D "Install_Dir" "$INSTDIR"
  
  ${EnvVarUpdate} $0 "T3D_HOME" "A" "HKLM" $INSTDIR
  ${EnvVarUpdate} $0 "PATH" "A" "HKLM" $INSTDIR
  
  ReadRegStr $2 HKLM "SOFTWARE\JavaSoft\Java Development Kit\1.6" "JavaHome"
  StrCmp $2 "" 0 registerJavaHome
  ReadRegStr $2 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\1.6" "JavaHome"
  StrCmp $2 "" 0 registerJavaHome
registerJavaHome:
  Push JAVA_HOME
  Push $2
  Call WriteEnvStr

  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}" "DisplayName" "${AppName}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
SectionEnd

Section "T3D Sample Files"
  SetOutPath $INSTDIR\samples
  
  File /r /x ".svn" /x ".project" "..\..\t3d-examples\*.*"
SectionEnd

;-----------------------------------------------------------------------------------------------------------------------------
; Start Menu Section
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\${AppName}"
  CreateShortCut "$SMPROGRAMS\${AppName}\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\${AppName}\T3D Documentation.lnk" "$INSTDIR\t3d-documentation.pdf" 
  CreateShortCut "$SMPROGRAMS\${AppName}\T3D Default CSS File.lnk" "$INSTDIR\css\doc.css" 

  SetOutPath $INSTDIR\samples
  CreateShortCut "$SMPROGRAMS\${AppName}\Samples Folder.lnk" "$INSTDIR\samples" 
;  CreateShortCut "$SMPROGRAMS\${AppName}\T3D Configuration Directory.lnk" "$APPDATA\T3D\"
  CreateShortCut "$SMPROGRAMS\${AppName}\Samples Folder (Command-Line).lnk" "$WINDIR\system32\cmd.exe"
SectionEnd

;-----------------------------------------------------------------------------------------------------------------------------
; Uninstaller
Section "Uninstall"
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}"
  DeleteRegKey HKLM SOFTWARE\ETSI\${AppName}

  MessageBox MB_OKCANCEL|MB_ICONINFORMATION $(ConfirmUninstall) IDOK +2
  Abort
  RMDir /r $INSTDIR

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\${AppName}\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\${AppName}"
  RMDir "$INSTDIR"
  RMDir "$PROGRAMFILES\ETSI"

  ; Remove Environment Variables
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKLM" $INSTDIR
  Push T3D_HOME
  Call un.DeleteEnvStr
  Push T3D_HOME
  Call un.DeleteEnvStr
SectionEnd

;-----------------------------------------------------------------------------------------------------------------------------
Function GetJRE
        MessageBox MB_OK "${PRODUCT_NAME} uses Java ${JRE_VERSION}, it will now \
                         be downloaded and installed"
 
        StrCpy $2 "$TEMP\Java Runtime Environment.exe"
        nsisdl::download /TIMEOUT=30000 ${JRE_URL} $2
        Pop $R0 ;Get the return value
                StrCmp $R0 "success" +3
                MessageBox MB_OK "Download failed: $R0"
                Quit
        ExecWait $2
        Delete $2
FunctionEnd
 
;-----------------------------------------------------------------------------------------------------------------------------
Function DetectJRE
  ReadRegStr $2 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" \
             "CurrentVersion"
  StrCmp $2 ${JRE_VERSION} done
 
  Call GetJRE
 
  done:
FunctionEnd

;-----------------------------------------------------------------------------------------------------------------------------
Function .onInstSuccess
  MessageBox MB_OK "You have successfully installed ${PRODUCT_NAME}. You can now use 't3d' on the command-line!"
FunctionEnd
 
;-----------------------------------------------------------------------------------------------------------------------------
;Function un.onUninstSuccess
;  MessageBox MB_OK "You have successfully uninstalled ${PRODUCT_NAME}."
;FunctionEnd

;-----------------------------------------------------------------------------------------------------------------------------
Function .onInit
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${AppName}" \
  "UninstallString"
  StrCmp $R0 "" done
 
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "${AppName} is already installed. $\n$\nClick `OK` to remove the \
  previous version or `Cancel` to cancel this upgrade." \
  IDOK uninst
  Abort
 
;Run the uninstaller
uninst:
  ClearErrors
  ExecWait '$R0 _?=$INSTDIR' ;Do not copy the uninstaller to a temp file
 
  IfErrors no_remove_uninstaller
    ;You can either use Delete /REBOOTOK in the uninstaller or add some code
    ;here to remove the uninstaller. Use a registry key to check
    ;whether the user has chosen to uninstall. If you are using an uninstaller
    ;components page, make sure all sections are uninstalled.
  no_remove_uninstaller:
 
done:
FunctionEnd