/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class MiscTools {
    public static String readFile(String filename) {
        String content = "";
        try {
            FileInputStream fis = new FileInputStream(filename);
            int x = fis.available();
            byte[] b = new byte[x];
            fis.read(b);
            content = new String(b);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static void writeFile(String filename, String content) {
        File targetDir = new File(filename).getParentFile();
        try {
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                System.out.println("IO ERROR: Creating the directory structure for \"" + filename + "\" failed!");
            }
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fos));
                w.write(content);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SecurityException se) {
            System.out.println("IO ERROR: Could not create ouput files and / or directories!Caused by: \"" + filename + "\"");
        }
    }

    public static void streamCopyFile(String sourceFilename, String targetFilename) {
        try {
            File targetFile = new File(targetFilename);
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                System.out.println("IO ERROR: Creating the directory structure for \"" + targetFilename + "\" failed!");
            }
            FileOutputStream outStream = new FileOutputStream(targetFile);
            FileInputStream inStream = new FileInputStream(sourceFilename);
            try {
                int c;
                while ((c = inStream.read()) != -1) {
                    outStream.write(c);
                }
            }
            catch (IOException e) {
                System.out.println("IO ERROR: Caused while copying: \"" + sourceFilename + "\" to \"" + targetFilename + "\"");
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("IO ERROR: File not found: \"" + sourceFilename + " / " + targetFilename + "\"");
            e1.printStackTrace();
        }
    }

    public static String getSubPath(String basePath, String resourcePath) {
        String subPath = resourcePath.substring(basePath.length());
        return subPath;
    }
}

