#include "CheckIsNotRegistered.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string CheckIsNotRegistered::CheckIsNotRegisteredId = "UE_CHECK_IS_NOT_REGISTERED";

CheckIsNotRegistered::CheckIsNotRegistered()
{
  m_successor.reset();
}

CheckIsNotRegistered::CheckIsNotRegistered(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckIsNotRegistered();
  m_eutIface = eutIface;
}

CheckIsNotRegistered::~CheckIsNotRegistered()
{
  Logger::Instance().LogInfo("CheckIsNotRegistered::~CheckIsNotRegistered");
  m_successor.reset();
}

int CheckIsNotRegistered::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  if (trigger == CheckIsNotRegistered::CheckIsNotRegisteredId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "CheckIsNotRegistered::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckIsNotRegistered::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void CheckIsNotRegistered::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

