#ifndef LIBCOMMON_CODETS_H
#define LIBCOMMON_CODETS_H

#include <t3devlib/t3devlib.h>
#include <t3devlib/generator.h>

namespace t3devlib { namespace gen {

//
// Implementation of subtypes defined in the module LibCommon_DataStrings
//

// types to be coded as a fixed-lengh string
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit1, Bitstring, 1)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit2, Bitstring, 2)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit3, Bitstring, 3)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit4, Bitstring, 4)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit5, Bitstring, 5)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit6, Bitstring, 6)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit7, Bitstring, 7)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit8, Bitstring, 8)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit9, Bitstring, 9)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit10, Bitstring, 10)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit11, Bitstring, 11)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit12, Bitstring, 12)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit13, Bitstring, 13)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit14, Bitstring, 14)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit15, Bitstring, 15)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit16, Bitstring, 16)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit17, Bitstring, 17)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit18, Bitstring, 18)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit19, Bitstring, 19)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit20, Bitstring, 20)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit21, Bitstring, 21)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit22, Bitstring, 22)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit23, Bitstring, 23)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit24, Bitstring, 24)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit25, Bitstring, 25)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit26, Bitstring, 26)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit27, Bitstring, 27)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit28, Bitstring, 28)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit29, Bitstring, 29)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit30, Bitstring, 30)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit31, Bitstring, 31)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit32, Bitstring, 32)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit48, Bitstring, 48)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit64, Bitstring, 64)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Bit128, Bitstring, 128)

T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct1, Octetstring, 8)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct2, Octetstring, 16)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct3, Octetstring, 24)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct4, Octetstring, 32)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct5, Octetstring, 40)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct6, Octetstring, 48)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct7, Octetstring, 56)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct8, Octetstring, 64)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct9, Octetstring, 72)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct10, Octetstring, 80)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct11, Octetstring, 88)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct12, Octetstring, 96)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct13, Octetstring, 104)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct14, Octetstring, 112)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct15, Octetstring, 120)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct16, Octetstring, 128)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct80, Octetstring, 640)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct128, Octetstring, 1024)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct160, Octetstring, 1280)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct320, Octetstring, 2560)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct640, Octetstring, 5120)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct1280, Octetstring, 10240)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_DataStrings, Oct1380, Octetstring, 11040)

T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_DataStrings, Oct1to15, Octetstring, (1*8), (15*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_DataStrings, Oct6to15, Octetstring, (6*8), (15*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_DataStrings, Oct1to128, Octetstring, (1*8), (128*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_DataStrings, Oct1to254, Octetstring, (1*8), (254*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_DataStrings, Oct1to255, Octetstring, (1*8), (255*8));


//
// Implementation of subtypes defined in the module LibCommon_TextStrings
//

// types to be coded as a fixed-lengh string
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String1, Charstring, 8)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String2, Charstring, 16)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String3, Charstring, 24)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String4, Charstring, 32)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String5, Charstring, 40)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String6, Charstring, 48)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String7, Charstring, 56)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String8, Charstring, 64)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String9, Charstring, 72)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String10, Charstring, 80)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String11, Charstring, 88)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String12, Charstring, 96)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String13, Charstring, 104)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String14, Charstring, 112)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String15, Charstring, 120)
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, String16, Charstring, 128)

// types to be coded as variable-length string withing a range
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, String1To63, Charstring, (1*8), (63*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, String1To64, Charstring, (1*8), (64*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, String1To127, Charstring, (1*8), (127*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, String1To128, Charstring, (1*8), (128*8));
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, String1To255, Charstring, (1*8), (255*8));

// TODO: content restrictions
typedef t3devlib::Charstring AlphaNum;
T3DEVLIB_FIXED_STRING_DEFINITION(LibCommon_TextStrings, AlphaNum2, Charstring, 16)
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (LibCommon_TextStrings, AlphaNum1To32, Charstring, (1*8), (32*8));


//
// Implementation of subtypes defined in the module LibCommon_BasicTypesAndValues
//

// types to be coded as fixed-width integer in the big-endian format
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt, Unsigned, 64) // limit
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt1, Unsigned, 1)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt2, Unsigned, 2)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt3, Unsigned, 3)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt4, Unsigned, 4)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt5, Unsigned, 5)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt6, Unsigned, 6)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt7, Unsigned, 7)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt8, Unsigned, 8)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt9, Unsigned, 9)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt10, Unsigned, 10)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt11, Unsigned, 11)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt12, Unsigned, 12)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt13, Unsigned, 13)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt14, Unsigned, 14)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt15, Unsigned, 15)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt16, Unsigned, 16)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt17, Unsigned, 17)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt18, Unsigned, 18)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt19, Unsigned, 19)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt20, Unsigned, 20)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt21, Unsigned, 21)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt22, Unsigned, 22)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt23, Unsigned, 23)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt24, Unsigned, 24)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt25, Unsigned, 25)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt26, Unsigned, 26)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt27, Unsigned, 27)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt28, Unsigned, 28)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt29, Unsigned, 29)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt30, Unsigned, 30)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt31, Unsigned, 31)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt32, Unsigned, 32)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, UInt48, Unsigned, 48)

T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int, Signed, 64) // limit
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int1, Signed, 1)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int2, Signed, 2)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int3, Signed, 3)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int4, Signed, 4)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int5, Signed, 5)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int6, Signed, 6)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int7, Signed, 7)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int8, Signed, 8)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int9, Signed, 9)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int10, Signed, 10)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int11, Signed, 11)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int12, Signed, 12)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int13, Signed, 13)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int14, Signed, 14)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int15, Signed, 15)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int16, Signed, 16)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int17, Signed, 17)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int18, Signed, 18)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int19, Signed, 19)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int20, Signed, 20)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int21, Signed, 21)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int22, Signed, 22)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int23, Signed, 23)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int24, Signed, 24)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int25, Signed, 25)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int26, Signed, 26)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int27, Signed, 27)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int28, Signed, 28)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int29, Signed, 29)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int30, Signed, 30)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int31, Signed, 31)
T3DEVLIB_INTEGER_DEFINITION(LibCommon_BasicTypesAndValues, Int32, Signed, 32)


}} // namespaces

#endif

