/**
 * @file CapturedData.h
 * This header file defines the CapturedData class.
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#ifndef CAPTURED_DATA_H
#define CAPTURED_DATA_H

#include "TrafficCaptureMessage.h"
#include "TrafficCaptureMessageId.h"

/**
 * This class describes a message used for passing captured data to the lower tester.
 */
class CapturedData : public TrafficCaptureMessage
{
private:
	char * m_pCapturedData;
	unsigned int m_nCapturedLen;
	struct timeval m_timestamp;
	ECaptureType m_captureType;
protected:
	virtual unsigned int CalculateDataLength();
	virtual void EncodePayload(unsigned int & nOffset);
	virtual bool DecodePayload(const char * pPayload, unsigned int nPayloadLength, unsigned int & nOffset);
public:
	CapturedData(void);
	virtual ~CapturedData(void);
	virtual unsigned short GetId() const { return CAPTURED_PACKET_IND; }
	/**
	 * Stores captured data.
	 * @param nLen Length of the captured data
	 * @param pData Buffer containing the captured data
	 */
	void SetData (int nLen, const char * pData);
	/**
	 * Returns the length of captured data.
	 * @return Length of the captured data
	 */
	int GetDataLength() const { return m_nCapturedLen; };
	/**
	 * Return a pointer to the buffer containing captured data.
	 * @return Pointer to captured data
	 */
	const char * GetData() const { return m_pCapturedData; }
	/**
	 * Sets the time when capture has occurred.
	 * @param timestamp Time of capture
	 */
	void SetTimestamp(struct timeval timestamp);
	/**
	 * Returns time of capture.
	 * @return Time of capture
	 */
	struct timeval GetTimestamp() const { return m_timestamp; }
	/**
	 * Sets a type of device that captured the data
	 * @param captureType Type of capturing device
	 */
	void SetCaptureType(ECaptureType captureType);
	/**
	 * Returns a type of device that captured the data
	 * @return Type of capturing device
	 */
	ECaptureType GetCaptureType() const { return m_captureType; }
	/**
	 * Converts the object to a string. Used for logging purposes
	 * @return String representation of the object.
	 */
	std::string ToString();
};

#endif
