#include "CheckNewMediaAdded.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckNewMediaAdded::CheckNewMediaAddedId = "UE_CHECK_NEW_MEDIA_STREAM_IS_ADDED";

CheckNewMediaAdded::CheckNewMediaAdded()
{
  m_successor.reset();
}

CheckNewMediaAdded::CheckNewMediaAdded(boost::shared_ptr<EutIPInterface> eutIface)
{
  CheckNewMediaAdded();
  m_eutIface = eutIface;
}

CheckNewMediaAdded::~CheckNewMediaAdded()
{
  Logger::Instance().LogInfo("CheckNewMediaAdded::~CheckNewMediaAdded");
  m_successor.reset();
}

int CheckNewMediaAdded::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckNewMediaAdded::CheckNewMediaAddedId)
  {
    ss << "CheckNewMediaAdded::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckNewMediaAdded::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckNewMediaAdded::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

