#ifndef ISUP_CODETS_H
#define ISUP_CODETS_H

#include <t3devlib/t3devlib.h>
#include <t3devlib/generator.h>

namespace t3devlib { namespace gen {

//
// Implementation of subtypes defined in the module SipIsup_ISUP_ParamTypes
//

// types to be coded as a fixed-lengh string
T3DEVLIB_FIXED_STRING_DEFINITION(SipIsup_ISUP_ParamTypes, CallInstanceCode, Octetstring, 32);
T3DEVLIB_FIXED_STRING_DEFINITION(SipIsup_ISUP_ParamTypes, FAI_PAR_v, Bitstring, 8);
T3DEVLIB_FIXED_STRING_DEFINITION(SipIsup_ISUP_ParamTypes, CGC_PAR_v, Bitstring, 8);
T3DEVLIB_FIXED_STRING_DEFINITION(SipIsup_ISUP_ParamTypes, TMR_PAR_v, Bitstring, 8);

// aliases (subtypes without restrictions)
T3DEVLIB_BASIC_DEFINITION(SipIsup_ISUP_ParamTypes, APMUserInformation_g1, Octetstring);

// types to be coded as variable-length string withing a range
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (SipIsup_ISUP_ParamTypes, Oct1to2, Octetstring, 8, 16);
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (SipIsup_ISUP_ParamTypes, Oct0to4, Octetstring, 0, 32);
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (SipIsup_ISUP_ParamTypes, Oct0to8, Octetstring, 0, 64);
T3DEVLIB_VARIABLE_SIZE_STRING_DEFINITION (SipIsup_ISUP_ParamTypes, Oct0to9, Octetstring, 0, 72);

// EOP is a 8-bit bitstring that must contain '00000000'B.
//
// We implement directly this class to ensure that the value is correct
// when decoding such a value.
class EOP : public Bit8
{
public:
	const char* GetModuleName() const { return "SipIsup_ISUP_ParamTypes"; }
	const char* GetTypeName() const   { return "EOP"; }

	void Decode (Buffer& buffer) throw (DecodeError) {
		Bit8::Decode (buffer);
		if ((GetLength() != 8) || (*GetValueBin() != '\0')) {
			throw DecodeError (this, "Malformed EOP (must have null value)");
		}
	}
};


}} // namespaces

#endif

