#include "Register.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
string Register::RegisterId = "UE_REGISTRATION";

Register::Register()
{
  m_successor.reset();
}

Register::Register(boost::shared_ptr<EutIPInterface> eutIface)
{
  Register();
  m_eutIface = eutIface;
}

Register::~Register()
{
  Logger::Instance().LogInfo("Register::~Register");
  m_successor.reset();
}

int Register::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;

  // Process the command.
  if (trigger == Register::RegisterId)
  {
    int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
    ss.str("");
    ss << "Register::Process: result=" << result;
    Logger::Instance().LogDebug(ss.str());
    if (result != 0)
    {
      // Processing failed.
      return 1; // Error - See TTCN-3 FncRetCode 
    }
    
    return 0/*result*/; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "Register::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // Error - See TTCN-3 FncRetCode 
}

void Register::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

