#ifndef TriggerCommandsOffLine_Default_h
#define TriggerCommandsOffLine_Default_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
/*! Class Default
 * \brief This class provides processing for the default Trigger command behavior.
 */
class Default : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
public:
  Default();
  ~Default();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor) { };
};

} } } // namespaces

#endif // TriggerCommandsOffLine_Default_h

