#include "CheckNewMediaRemoved.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckNewMediaRemoved::CheckNewMediaRemovedId = "UE_CHECK_NEW_MEDIA_STREAM_IS_REMOVED";

CheckNewMediaRemoved::CheckNewMediaRemoved()
{
  m_successor.reset();
}

CheckNewMediaRemoved::~CheckNewMediaRemoved()
{
  Logger::Instance().LogInfo("CheckNewMediaRemoved::~CheckNewMediaRemoved");
  m_successor.reset();
}

int CheckNewMediaRemoved::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckNewMediaRemoved::CheckNewMediaRemovedId)
  {
    ss << "CheckNewMediaRemoved::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckNewMediaRemoved::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckNewMediaRemoved::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

