#include "CheckCallIsEnded.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsOffLine {
  
string CheckCallIsEnded::CheckCallIsEndedId = "UE_CHECK_CALL_IS_ENDED";

CheckCallIsEnded::CheckCallIsEnded()
{
	m_successor.reset();
}

CheckCallIsEnded::~CheckCallIsEnded()
{
  Logger::Instance().LogInfo("CheckCallIsEnded::~CheckCallIsEnded");
  m_successor.reset();
}

int CheckCallIsEnded::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  // Process the command.
  if (trigger == CheckCallIsEnded::CheckCallIsEndedId)
  {
    ss << "CheckCallIsEnded::Process: " << trigger;
    Logger::Instance().LogDebug(ss.str());
    return 0; // See TTCN-3 FncRetCode 
  }
  else if (m_successor.get() != NULL)
  {
    ss << "CheckCallIsEnded::Not supported command: " << trigger;
    Logger::Instance().LogInfo(ss.str());
    return m_successor.get()->Process(trigger, parameterList);
  }

  return 1; // See TTCN-3 FncRetCode 
}

void CheckCallIsEnded::SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor)
{
  m_successor = successor;
};
} } } // namespaces

