#ifndef TriggerCommandsGUI_Register_h
#define TriggerCommandsGUI_Register_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class Register
 * \brief This class provides processing for REGISTER Trigger command.
 */
class Register : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string RegisterId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  Register();
  Register(boost::shared_ptr<EutIPInterface> eutIface);
  ~Register();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_Register_h

