#ifndef TriggerCommandsGUI_Default_h
#define TriggerCommandsGUI_Default_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class Default
 * \brief This class provides processing for the default Trigger command behavior.
 */
class Default : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  Default();
  Default(boost::shared_ptr<EutIPInterface> eutIface);
  ~Default();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor) { };
};

} } } // namespaces

#endif // TriggerCommandsGUI_Default_h

