#include "Default.h"
#include <sstream>
#include <iostream>

#include "Logger/Logger.h"

#include "UEUserGuideClient.h"

using namespace std;
using namespace boost;

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
Default::Default()
{
}

Default::Default(boost::shared_ptr<EutIPInterface> eutIface)
{
  Default();
  m_eutIface = eutIface;
}

Default::~Default()
{
  Logger::Instance().LogInfo("Default::~Default");
}

int Default::Process(const string &trigger, const vector<string> &parameterList)
{
  stringstream ss;
  
  // Process the command.
  int result = UEUserGuideClient::Instance().SendCommand(m_eutIface, trigger, parameterList);
  ss.str("");
  ss << "Default::Process: result=" << result;
  Logger::Instance().LogDebug(ss.str());
  if (result != 0)
  {
    // Processing failed.
    return 1; // Error - See TTCN-3 FncRetCode 
  }
  
  return 0/*result*/; // See TTCN-3 FncRetCode 
}
} } } // namespaces

