#ifndef TriggerCommandsGUI_SendMessage_h
#define TriggerCommandsGUI_SendMessage_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class SendMessage
 * \brief This class provides processing for UE_CHECK_NEW_MEDIA_STREAM_IS_ADDED Trigger command.
 */
class CheckNewMediaAdded : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string SendMessageId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckNewMediaAdded();
  CheckNewMediaAdded(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckNewMediaAdded();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_SendMessage_h

