#ifndef TriggerCommandsGUI_CheckIsRegistered_h
#define TriggerCommandsGUI_CheckIsRegistered_h

#include <boost/shared_ptr.hpp>
#include <string>
#include <iostream>

#include "Processors/TriggerCommandsImpl.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
namespace TriggerCommandsGUI {
  
/*! Class CheckIsRegistered
 * \brief This class provides processing for UE_CHECK_CALL_IS_REGISTED Trigger command.
 */
class CheckIsRegistered : public UpperTestAdapter::Processors::TriggerCommandsImpl
{
  static std::string CheckIsRegisteredId;
  
  boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> m_successor;
  
  boost::shared_ptr<EutIPInterface> m_eutIface;
  
public:
  CheckIsRegistered();
  CheckIsRegistered(boost::shared_ptr<EutIPInterface> eutIface);
  ~CheckIsRegistered();
  
public: // Public interface.
  int Process(const std::string &trigger, const std::vector<std::string> &parameterList);
  void SetSuccessor(boost::shared_ptr<UpperTestAdapter::Processors::TriggerCommandsImpl> successor);
};

} } } // namespaces

#endif // TriggerCommandsGUI_CheckIsRegistered_h

