#ifndef Processors_TriggerCommandsImpl_h
#define Processors_TriggerCommandsImpl_h

#include <boost/shared_ptr.hpp>
#include <iostream>
#include <string>
#include <vector>

#include "Helper/GeneralConfigurationParams.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
/*! Interface ITriggerCommandsImpl
 * \brief This interface provides support for TriggerCommands message processing in local or remote mode.
 * This is the entry point of the Chain of responsability pattern.
 */
class TriggerCommandsImpl
{
public: // Public interface.
  //! SetEutIpInterface.
  /*! Initialize the EUT IP interface.
   * @param iface: .EUT IP interface.
   */
  virtual void SetEutIpInterface(boost::shared_ptr<EutIPInterface> iface) {};
  //! Process.
  /*! Process the Trigger command message.
   * @param command: trigger command to execute
   * @param params: Comand parameters
   * @return FncRetCode value on success, -1 otherwise.
   */
  virtual int Process(const std::string &trigger, const std::vector<std::string> &parameterList) { return false; };
  //! SetSuccessor.
  /*! Process the TriggerCommands message. This is a 
   * @param successor: Nest command to process
   */
  virtual void SetSuccessor(boost::shared_ptr<TriggerCommandsImpl> successor) { };
};

} } // namespaces

#endif // Processors_TriggerCommandsImpl_h

