#ifndef Processors_ProcessorImpl_h
#define Processors_ProcessorImpl_h

// Boost headers.
#include <boost/shared_ptr.hpp>
// Standard headers.
#include <iostream>
#include <string>
#include <vector>
// Interface on Trigger commands processing.
#include "Processors/TriggerCommandsStrategy.h"
#include "Helper/GeneralConfigurationParams.h"

namespace UpperTestAdapter {
  
namespace Processors {
  
/*! Interface ProcessorImpl
 * \brief This interface provides support for TriggerCommands message processing in local or remote mode.
 */
class ProcessorsImpl
{
public: // Public interface.
  //! SetImplMode.
  /*! Initialize the communication mode.
   * @param strategy: The staretgy to use.
   */
	virtual void SetImplMode(TriggerCommandsStrategy::Strategies strategy) {};
  //! SetEutIpInterface.
  /*! Initialize the EUT IP interface.
   * @param eutIface: .EUT IP interface.
   */
  virtual void SetEutIpInterface(boost::shared_ptr<EutIPInterface> eutIface) {};
 //! Process.
  /*! Process the TriggerCommands message in synchronous mode.
   * @param trigger: trigger command to execute
   * @param params: Trigger parameters list
   * @return FncRetCode value on success, -1 otherwise.
   */
  virtual int Process(const std::string &trigger, const std::vector<std::string> &parameterList) { return false; };
};

} } // namespaces

#endif // Processors_ProcessorImpl_h

