#ifndef MessagesIdentifiers_h
#define MessagesIdentifiers_h

#include <t3devlib/t3devlib.h>

class MessagesIdentifiers
{
 public:
    static const char* GeneralConfigurationReq;
    static const char* GeneralConfigurationRsp;
    static const char* SetFilterReq;
    static const char* SetFilterRsp;
    static const char* StartTrafficCaptureReq;
    static const char* StartTrafficCaptureRsp;
    static const char* StopTrafficCaptureReq;
    static const char* StopTrafficCaptureRsp;
    static const char* EquipmentOperationReq;
    static const char* EquipmentOperationRsp;
    static const int Size;
    static const char* Messages[];
    
    static unsigned char GetIdx(const std::string& message)
    {
      // Sanity check.
      if (message.length() == 0)
      {
        return 0xff;
      }
      
      // Get index
      const char ** ppEnum = MessagesIdentifiers::Messages;
      int i = 0;
      while (*(ppEnum[i]) && strcmp(ppEnum[i], message.c_str()) != 0)
        i++;
      if (*(ppEnum[i]) == 0) { // Not found.
        return 0xff;
      }

      return static_cast<unsigned char>(i);
    };
    
    static std::string GetMessage(int idx)
    {
      // Sanity check.
      if (idx >=MessagesIdentifiers::Size)
      {
        return std::string("");
      }
      
      return std::string(Messages[idx]);
    }
 };

#endif // MessagesIdentifiers_h

