/**
 * @file TrafficCaptureMessageFactory.h
 * This header file defines the TrafficCaptureMessageFactory.
 * @author Tomas Urban
 * @version 0.2
 * @date 23/07/2009
 */
#ifndef TRAFFIC_CAPTURE_MESSAGE_FACTORY_H
#define TRAFFIC_CAPTURE_MESSAGE_FACTORY_H
#include "TrafficCaptureMessage.h"
#include "Helper/Singleton.h"

/**
 * A singleton factory class for instantiating received data messages.
 */
class TrafficCaptureMessageFactory  : public Singleton<TrafficCaptureMessageFactory>
{
private:
	friend class Singleton<TrafficCaptureMessageFactory>;
	TrafficCaptureMessageFactory(void);
public:
	~TrafficCaptureMessageFactory(void);
	/**
	 * The factory method for creating message instances from data received via TCP/IP
	 * connection. The objects returned by this method are allocated on the heap, so they
	 * have to be disposed when they are not needed anymore by the \c delete operator or
	 * calling the #DisposeMessage method. When creating the message instances, the 
	 * factory decodes the payload. Thus, the created object are fully initialized.
	 * @param nId Message identification number
	 * @param pPayload Buffer containing encoded payload data
	 * @param nPayloadLength Lenght of the payload data
	 * @return Created message instance or \c NULL if any error has ocurred (e.g. unknown
	 * message code, decoding failure).
	 */
	TrafficCaptureMessage * CreateMessage(unsigned short nId, const char * pPayload, 
		unsigned int nPayloadLength);
	/**
	 * This method is used for disposing instances allocated by the #CreateMessage method.
	 * @param pInstance Message instance to be disposed
	 */
	void DisposeMessage(TrafficCaptureMessage * pInstance);
};

#endif
